# Pulls in resources from provided data.
#
class nrdc::resources {
  include ::nrdc
  # Use hiera if it's available, else fall back to provided data.
  $servicechecks = pick_default(hiera_hash('nrdc::servicechecks', {}), $nrdc::servicechecks)
  $receivers     = pick_default(hiera_hash('nrdc::receivers', {}), $nrdc::receivers)
  $servers       = pick_default(hiera_hash('nrdc::servers', {}), $nrdc::servers)
  $metrics       = pick_default(hiera_hash('nrdc::metrics', {}), $nrdc::metrics)

  if !empty($servicechecks) {
    ensure_resources('nrdc::servicecheck', $servicechecks)
  }
  if !empty($receivers) {
    ensure_resources('nrdc::receiver', $receivers)
  }
  if !empty($servers) {
    ensure_resources('nrdc::server', $servers)
  }
  if !empty($metrics) {
    ensure_resources('nrdc::metrics', $metrics)
  }
}
