# Allows arbitrary definition of master service-check servers.
#
define nrdc::server (
  $url           = $name,
  $http_vars     = '',
  $method        = 'GET',
  $timeout       = '10s',
  $interval      = '5m',
  $template_path = 'nrdc/server.erb',
  $filename      = join([regsubst($name, '[?/&: ]', '_', 'G'), '.conf']),
) {
  include ::nrdc

  ensure_resource('file', "${nrdc::include_dir}/${filename}", {
    ensure  => pick($nrdc::ensure, 'absent'),
    content => template($template_path),
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
  })
}
