# Creates service checks for NRDC. Using this will install NRDC.
#
define nrdc::servicecheck (
  $command,
  $ensure         = present,
  $handler        = '',
  $hostname       = '',
  $service_name   = $name,
  $timeout        = 60,
  $interval       = 5,
  $retry_interval = join(values_at(sort([0+2, 0+pick($interval, 5)]), 0)),
  $retry          = 3,
  $template_path  = 'nrdc/servicecheck.erb',
  $user           = '',
  $ignore         = false,
) {
  include ::nrdc

  validate_integer($timeout)
  validate_integer($interval)
  validate_integer($retry_interval)
  validate_integer($retry)
  validate_string($command, $handler, $hostname)
  validate_string($service_name, $template_path, $user)
  validate_bool($ignore)

  if $nrdc::ensure == 'present' and $ensure == 'present' {
    $_ensure = present
  } else {
    $_ensure = absent
  }

  ensure_resource('file', "${nrdc::service_path}/${service_name}", {
    ensure  => $_ensure,
    content => template($template_path),
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
  })
}
