# offnet_netrr::dumbo_repo instance type
define offnet_netrr::dumbo_repo(
  $ensure      = 'present',
  $environment = pick($::twitch_environment, $twitch_environment),
  $account     = 'video-offnet',
  $region      = 'us-west-2',
  $cluster     = 'offnet-prodtest-sjc02',

) {

  $secret_path = "${account}/aws/${environment}/${cluster}/${::hostname}"

  $ensure_dir = $ensure ? {
    present => directory,
    default => absent,
  }

  File['dumbo.list', 'xenial.list'] -> Twitch_sandstorm_agent::Template['s3auth.conf']

  file { ['/usr/local/dumbo/etc/aws']:
    ensure  => $ensure_dir,
    force   => false,
    recurse => true,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
  }

  twitch_sandstorm_agent::template { 's3auth.conf':
    ensure      => $ensure,
    destination => '/etc/apt/s3auth.conf',
    contents    => template('offnet_netrr/s3auth.erb'),
    owner       => 'root',
    mode        => '0640',
  }

  twitch_sandstorm_agent::template { 'config':
    ensure      => $ensure,
    destination => '/usr/local/dumbo/etc/aws/config',
    contents    => template('offnet_netrr/config.erb'),
    owner       => 'root',
    mode        => '0640',
    require     => File['/usr/local/dumbo/etc/aws'],
  }

  if $ensure == 'present' {
    Twitch_sandstorm_agent::Template['s3auth.conf'] -> Package['apt-transport-s3']

    package { 'apt-transport-s3':
      ensure => $ensure,
    }
  }

  # trying to make these real apt resources causes a dep cycle.
  file { 'dumbo.list':
    ensure  => $ensure,
    path    => '/etc/apt/sources.list.d/dumbo_dumbo.list',
    owner   => 'root',
    mode    => '0644',
    content => 'deb [trusted=yes] s3://dumbo-repo.s3.amazonaws.com/ dumbo/',
  }

  file { 'xenial.list':
    ensure  => $ensure,
    path    => '/etc/apt/sources.list.d/dumbo_xenial.list',
    owner   => 'root',
    mode    => '0644',
    content => 'deb [trusted=yes] s3://dumbo-repo.s3.amazonaws.com/ xenial/',
  }

}
