# clss offnet_netrr
class offnet_netrr (
  $template        = $offnet_netrr::params::template,
  $consul_template = $offnet_netrr::params::consul_template,
  $env             = $offnet_netrr::params::env,
  $bgp_asn         = $offnet_netrr::params::bgp_asn,
  $bgp_community   = $offnet_netrr::params::bgp_community,
  $pops            = $offnet_netrr::params::pops,
) inherits offnet_netrr::params {

  include bird
  include twitch_svclogs
  include dumbo_wireguard

  bird::daemon { 'offnet_netrr':
    protocol        => 'bgp',
    bgp_asn         => $bgp_asn,
    bgp_community   => $bgp_community,
    template        => $template,
    consul_template => $consul_template,
    routed_subnet   => $::ipaddress_primary,
    bgp_announce    => $pops,
  }

  twitch_svclogs::logfile { 'bird_offnet_netrr':
    account      => 'twitch-dumbodrop',
    use_milliner => false,
  }

  $keys = keys($pops)
  notify { "netrr ${name}:": message => "creating clusters for ${keys}" }
  create_resources(dumbo_wireguard::cluster, $pops)

}
