# class overused_ips
class overused_ips (
  $env                = $overused_ips::params::env,
  $canary             = $overused_ips::params::canary,
  $ip_tokens_hostname = $overused_ips::params::ip_tokens_hostname,
  $ip_tokens_path     = $overused_ips::params::ip_tokens_path,
  $ip_tokens_port     = $overused_ips::params::ip_tokens_port,
  $statsd_path        = $overused_ips::params::statsd_path,
  $statsd_port        = $overused_ips::params::statsd_port,
  $listen_port        = $overused_ips::params::listen_port,
  $whitelist_path     = $overused_ips::params::whitelist_path,
  $overused_ips_dir   = $overused_ips::params::overused_ips_dir,
  $dbopt_suffix       = $overused_ips::params::dbopt_suffix,
) inherits overused_ips::params {

  validate_string( $env,
                  $ip_tokens_hostname,
                  $ip_tokens_path,
                  $ip_tokens_port,
                  $statsd_path,
                  $statsd_port,
                  $listen_port,
                  $whitelist_path )

  file { $whitelist_path:
    ensure  => present,
    source  => 'puppet:///modules/overused_ips/whitelist.toml',
    require => Twitch::Service['overused_ips'],
  }

  $overused_ips_cmd = join([
    './overused_ips',
    "-ip-tokens-hostname=${ip_tokens_hostname}",
    "-ip-tokens-path=${ip_tokens_path}",
    "-ip-tokens-port=${ip_tokens_port}",
    "-listen-port=${listen_port}",
    "-whitelist-path=${whitelist_path}",
    "-statsd-addr=${statsd_path}",
    "-statsd-port=${statsd_port}",
    "-dbopt-suffix=${dbopt_suffix}",
  ], ' ')

  twitch::service { 'overused_ips':
    daemon_cmd            => $overused_ips_cmd,
    predaemon             => [],
    service_repo          => 'video/overused_ips',
    user                  => 'nobody',
    env                   => $env,
    canary                => $canary,
    manage_service        => false,
    base_dir              => '/home/jtv',
    app_dir               => $overused_ips_dir,
    consul_advertise_port => $listen_port,
  }
}
