# a pachyderm client certificate.
define pachyderm::client_cert (
  $ensure       = 'present',
  $owner_key    = 'video-offnet',
  $environment  = pick($::twitch_environment, $twitch_environment),
  $service_name = 'tls',
  $cluster      = undef,
) {

  twitch_sandstorm_agent::template { "${name}_bastion_cert.pem":
    ensure          => $ensure,
    key             => "${owner_key}/${service_name}/${environment}/${cluster}/${name}/bastion_cert.pem",
    destination     => "/opt/twitch/pachyderm/etc/clients/${name}.crt",
    restart_command => 'svc -t /etc/service/pachyderm',
  }

}
