# pachyderm daemons for offnet-origin role
class pachyderm (
  $ensure = 'present',
  $env    = pick($::twitch_environment, $twitch_environment),
  $canary = false,
  $edges  = {},
)
{

  $app_dir  = '/opt/twitch/pachyderm'
  $dumbo_etc = '/usr/local/dumbo/etc'
  $cert_prefix = "video/video-edge/production/${::pop}/wildcard_abs_hls_ttvnw_net"
  $bastion_args   = "current/bin/bastion -cluster-config ${dumbo_etc}/nodes.json -ssl-pem etc/bastion.pem -listen-stats localhost:8888"
  $pachyderm_args = "bin/pachyderm -certs ${app_dir}/etc/clients"

  package {'dumbo-nodeconfig-base':
    ensure => 'latest',
  }

  twitch::service {'pachyderm':
    daemontools_ensure    => $ensure,
    env                   => $env,
    user                  => 'pachyderm',
    app_dir               => $app_dir,
    canary                => $canary,
    predaemon             => [],
    daemon_cmd            => $pachyderm_args,
    service_repo          => 'dumbo/pachyderm',
    manage_service        => true,
    consul_advertise_port => 8085,
  }

  consul::service { 'pachyderm-nodesAPI':
    consul_tags => ['nodesAPI-reporter'],
    port        => 9000,
  }

  daemontools::supervise {'bastion':
    ensure         => $ensure,
    env            => $env,
    wd             => $app_dir,
    daemon_dir     => '/var/lib/service',
    syslog         => 'local3',
    user           => 'pachyderm',
    predaemon      => [],
    daemon         => "$bastion_args 2>&1",
    manage_service => true,
    require        => Twitch::Service['pachyderm'],
  }

  twitch_sandstorm_agent::template { 'bastion-ssl-pem':
    ensure          => $ensure,
    restart_command => 'svc -h /etc/service/bastion',
    template        => 'pachyderm/bastion.pem.erb',
    destination     => "${app_dir}/etc/bastion.pem",
    notify          => Daemontools::Supervise['bastion'],
    require         => Package['dumbo-nodeconfig-base'],
  }

  create_resources(pachyderm::client_cert, $edges)

}
