# Puppet Environment Workspace Provider

This is a utility to handle coordinating changes across multiple git repositories.
Currently written as a very ugly shell script that started as a few simple commands
wrapped around gita, it will be transitioned into python in the near future.

This utility allows grouping of repos, auto-stashes changes when switching environments,
runs bulk git commands across the repos in a group, and checks a few things against
the way our workflows generally work.

If anything is not working as expected, please let @mtheral know.
Generally, you should use git commands in each repo as you work, but use this utility
to handle switching branches and pushing code to places. If things get out of sync, 
sometimes using git directly to put somethign back into its expected place is easy.

Auto-stash uses a tagged git stash in git's built-in stash stack, but is limited to
a single stash depth. If you changes get lost in an auto-stash operation somehow,
use `git stash list` to see if you see your change set, then git pop \<stash-id\> to
try to pull the changes back into your current workset and remove from the stack.

While it will not create all the PRs for you, it can generate a list of URLs to the 
PR creation page for all repos in your environment that have changes needing PR.


## Usage

    pewp [options] <command> [args]
      Command           Description
        init              Initialize the util. Sets up the cache dir, clones control-repo and
                            hiera_data in the current dir. Currently, only one instance is
                            supported. Run this from the dir you want to have all your repos in.
        wd                print your workspace dir (where you ran init from).
        new <name> [module1, module2]
                          create new puppet environment. Without specifying modules, only creates
                            the branch in control-repo and hiera-data. Creates this from an
                            updated origin/HEAD branch
        env <name>        Switch to existing environment
        envs              List current local environments (same as gita group ls)
        mods              List available modules from Puppetfile
        ss                Show status on every repo in the current environment.
        status            List repos in current env and their details (same as gita ll)
        add <module>      Adds the specified module to the current environment. (clones if needed)
        rm <module>       Removes the specified module from the current environment. Errors if
                            changes are present and --force is not used.
        commit <message>  Commits current staged changeset in all modules of current environment with
                            message.(eq to 'git commit -am "message"' across all repos in the environment)
        pull              Issues 'git pull' across current environment
        push              Issues 'git push -u origin <environment>' across current environment if changes
                            are committed.
        test              Pushes the control-repo branch to origin to enable puppet testing
        untest            Deletes the control-repo branch from origin to disable puppet testing and clean up
        pr                Generates URLs for creating PRs. Only generates PR URLs for modules with committed
                            changes. Make sure to push first. Use test to push an unchanged control-repo
                            branch to enable testing.
        delete_from_origin  Removes the current environment (branches) from origin on all repos
                            in the environment.
        help              Shows this usage and exits.
    
      Options
        -f,--force    Ignore safety checks, try to push through as-is anyway. For commit, add all files first.
        -d,--debug    Debug: display commands and output, more debug output
    

It is highly recommended to init in an empty dir created just for this utility. It should work fine with
pre-existing git repos, but expects all repos to be in the same dir. 

### To Start

    mkdir \<new workspace dir\>; cd !:1
    pewp init
    pewp new \<new environment\> \<additional modules\>


## Installing

copy pewp to a location in your path (generally /usr/local/bin/).

## Dependency

pewp uses gita to manage git repo groupings. It will try to install this for you if it cannot locate it. Easy way is:
pip3 install gita, then copy \_\_main\_\_.py from its github project over what it installed 
(somewhere in /usr/local/lib/python3.x/site-packages/gita) and rm anything in \_\_pycache\_\_ there.

Source project is at https://github.com/nosarthur/gita

Note that you need to make sure the version is 12.6 or newer. (pip is still 12.2). This version includes 
2 patches we submitted, one fixes a bug in context removal, the other adds the ability to remove a repo 
from an environment. Without updated version, some commands might fail or act weird.

gita only supports python3, as such you might need to 'alias gita=python3 gita'
