class postgresql_repmgr::config inherits postgresql_repmgr {
    # if we want absent, or directory
    $ensure_dir = $ensure ? {
        'absent' => $ensure,
        default  => 'directory'
    }

    file { $repmgr_directory:
        ensure  => $ensure_dir,
        owner   => $postgres_user,
        group   => $postgres_group,
        mode    => '0700'
    }

    # repmgr v4 changed a few config options, see:
    # https://repmgr.org/docs/4.0/upgrading-from-repmgr-3.html
    # Using $::lsbdistcodename as v4 is not available on precise
    # from the postgresql ppa

    $repmgr_conf_templ = $::lsbdistcodename ? {
      'precise' => template("${module_name}/repmgr.conf.erb"),
      default   => template("${module_name}/repmgr4.conf.erb"),
    }

    twitch_sandstorm_agent::template{ 'repmgrconf':
        destination     => $repmgr_config,
        mode            => '0640',
        owner           => $postgres_user,
        group           => $postgres_group,
        restart_command => 'sudo svc -i /var/lib/service/repmgrd',
        contents        => $repmgr_conf_templ,
    }

    twitch_postgresql::lib::pgpass_line { "pgpass_repmgr":
      database_name => $db_cluster_name,
      database_env => $db_env,
      database_user => 'repmgr'
    }
}
