class postgresql_repmgr::cron inherits postgresql_repmgr {
    # if we're the master we want to install a cronjob
    # otherwise do absolutely nothing
    if ($is_master) {
        cron { $repmgr_cron_name:
            ensure  => $ensure,
            command => "repmgr -f ${repmgr_config} cluster cleanup 2>&1 | logger -p local2.info -t ${repmgr_cron_name}",
            user    => $postgres_user,
            minute  => 0,
            hour    => 13,
            weekday => 'Sun'
        }
    }
}
