class postgresql_repmgr (
    $db_cluster_name,
    $db_env,
    $rep_node_id,
    $ssh_key_name            = undef,
    $failover_priority       = 100,
    $upstream_id             = undef,
    $rep_node_name           = undef,
    $is_master               = false,
    $db_port                 = 5432,
    $ensure                  = 'present',
    $master_response_timeout = 60,
    $async_query_timeout     = 60,
    $reconnect_attempts      = 6,
    $reconnect_interval      = 10,
    $monitor_interval        = 2,
    $auto_failover           = false,
    $retry_promote_interval  = 300,
    $is_witness              = false,
    $witness_cluster_hosts   = undef,
    $ss_team                 = $postgresql_repmgr::params::ss_team
) inherits postgresql_repmgr::params {

    # make sure rep_node_id is a digit
    validate_re($rep_node_id, '^\d+$')
    # make sure db_cluster_name is lowercase word without numbers
    validate_re($db_cluster_name, '^[-_a-z]+$')
    # make sure we've been given absent or present
    validate_re($ensure, '^(absent|present)$')
    # postgresql version <major>.<minor>
    validate_re($postgresql_version, '^\d\.\d$')

    $node_name = $rep_node_name ? {
        undef => "node${rep_node_id}",
        default => $rep_node_name,
    }

    $host = $::fqdn

    if !($postgresql_version in $supported_versions) {
        fail("${module_name} does not support version $postgresql_version")
    }

    $use_repslots = $postgresql_version ? {
        '9.4'   => true,
        '9.5'   => true,
        default => false,
    }

    include postgresql_repmgr::lib::witness

    anchor { "${module_name}::start": } ->
    class { "${module_name}::install": } ->
    class { "${module_name}::config": } ->
    class { "${module_name}::cron": } ->
    class { "${module_name}::service": } ->
    class { "${module_name}::ssh": } ->
    anchor { "${module_name}::end": }
}
