define postgresql_repmgr::lib::hba_rule($ip, $database) {
  postgresql::server::pg_hba_rule { "${name} repmgr rule":
    description => "Repmgr access to ${database} from ${name}",
    type => 'host',
    database => $database,
    user => 'repmgr',
    address => "${ip}/32",
    auth_method => 'md5',
    order => "055-${database}-${name}",
  }
}
