class postgresql_repmgr::params {
    $postgres_user    = 'postgres'
    $postgres_group   = $postgres_user
    $ss_team          = 'data-team'

    $postgresql_version      = '9.6'
    $postgres_bin_dir        = "/usr/lib/postgresql/${postgresql_version}/bin"
    $postgres_directory      = "/var/lib/postgresql"
    $postgres_data_directory = "${postgres_directory}/${postgresql_version}/main"
    $repmgr_directory        = "${postgres_directory}/repmgr"
    $repmgr_config           = "${repmgr_directory}/repmgr.conf"
    $repmgr_log              = '/var/log/jtv/repmgr.log'

    # used on master databases as a cleanup job
    $repmgr_cron_name = 'repmgr_cluster_cleanup'

    # currently postgresql only has repmgr for these versions
    $supported_versions = [
        '9.0',
        '9.1',
        '9.2',
        '9.3',
        '9.4',
        '9.5',
        '9.6',
    ]
}
