# Configures DNS forwarding on hosts that do not have public IPs.
#
# This uses unbound to forward all queries to a resolver (dns-resolver anycast)
class profile_dns::forwarder_b (
  $anycast_address   = '10.254.0.8',
  $anycast_community = 16001,
  $forwarders        = ['10.254.0.4', '10.254.0.7', '10.254.0.9', '10.254.0.21', '10.254.0.32', '10.254.0.33'],
) {

  # This is the same as the 'a' profile, split because the anycast is different currently.
  class { 'profile_dns::forwarder_a':
    anycast_address   => $anycast_address,
    anycast_community => $anycast_community,
    forwarders        => $forwarders,
  }

}
