# Installs and configures proxy_monitor
class proxy_monitor (
  $svcname           = 'proxy_monitor',
  $proxymon_env      = $proxy_monitor::params::proxymon_env,
  $haproxy_inst_name = 'live',
  $ingest_ip         = $::ipaddress_primary,
  $ffmpeg_version    = "2.8.15-2${::lsbdistcodename}",
  $aws_region        = $::facts['default_region'],
) inherits proxy_monitor::params {

  include twitch::packages
  realize(Package['libspeex1'])
  realize(Package['libmp3lame0'])

  $_ffmpeg_version = $::lsbdistcodename ? {
    'bionic' => '7:4.4-3bionic',
    default  => $ffmpeg_version,
  }

  package { 'ffmpeg': ensure => $_ffmpeg_version }

  apt::pin { 'ffmpeg':
    ensure   => present,
    packages => 'ffmpeg',
    priority => 600,
    version  => $_ffmpeg_version,
  }

  twitch_svclogs::logfile { 'proxy_monitor':
    ensure             => 'present',
    use_default_region => true,
    log_group_name     => 'proxymonitor',
  }

  daemontools::supervise { $svcname:
    syslog         => 'local3',
    user           => 'nobody',
    wd             => '/home/jtv/proxy_monitor/current',
    predaemon      => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh', 'source /etc/milliner-client-env.sh'],
    daemon         => './proxy_monitor',
    options        => "--channel ${::fqdn} --pop ${::pop} --check-interval 50s --haproxy-config /etc/haproxy/haproxy-${haproxy_inst_name}.conf --env ${proxymon_env} --aws-region ${aws_region} 2>&1",
    manage_service => true,
  }

  consul::service { 'ingest-proxy-monitor':
    consul_tags => [$proxymon_env],
    port        => 0,
  }
}
