module Vagrant
  module Config
    module V2
      class Root
        def vm_facter(vm_facts, puppet_opts)
          vm.provision :puppet do |puppet|
            puppet.working_directory = '/vagrant'
            puppet.hiera_config_path = 'vagrant_hiera.yaml'
            puppet.manifests_path = 'manifests'
            puppet.module_path = 'modules'
            puppet.manifest_file  = 'site.pp'
            puppet.facter = vm_facts
            puppet.options = puppet_opts
          end
        end
      end
    end
  end
end
