# globalviewcount
#
# This service receives video session information from edgeviewcounter running
# on individual video edges and combines them into per-stream live viewcounts,
# filtering out attempts at gaming viewer numbers through fake sessions.
class globalviewcount (
  $env                           = $globalviewcount::params::env,
  $canary                        = $globalviewcount::params::canary,
  $overused_ips_hostname         = $globalviewcount::params::overused_ips_hostname,
  $overused_ips_port             = $globalviewcount::params::overused_ips_port,
  $overused_ips_path             = $globalviewcount::params::overused_ips_path,
  $globalviewcount_dir           = $globalviewcount::params::globalviewcount_dir,
  $listen_port                   = $globalviewcount::params::listen_port,
  $capnp_port                    = $globalviewcount::params::capnp_port,
  $memory_percent                = $globalviewcount::params::memory_percent,
  $dont_publish                  = $globalviewcount::params::dont_publish,
  $spade_env_override            = $globalviewcount::params::spade_env_override,
) inherits globalviewcount::params {
  include twitch_geoip

  validate_string(
    $overused_ips_hostname,
    $overused_ips_path,
    $globalviewcount_dir,
  )
  validate_bool($dont_publish)
  validate_integer($overused_ips_port)
  validate_integer($listen_port)
  validate_integer($capnp_port)

  $deploy_env = $::twitch_role ? {
    'globalviewcount-prev-prod' => 'prev-prod',
    default                     => $env,
  }

  $noop_flag = $deploy_env ? {
    'production' => $dont_publish,
    default      => true,
  }

  $spade_env = pick($spade_env_override, $deploy_env)

  $memory_limit = floor(($::memorysize_mb * 1024.0) * ($memory_percent / 100.0))

  $globalviewcount_cmd = join([
    './globalviewcount',
    "-overused-ips-hostname=${overused_ips_hostname}",
    "-overused-ips-port=${overused_ips_port}",
    "-overused-ips-path=${overused_ips_path}",
    "-listen-port=${listen_port}",
    "-capnp-listen-port=${capnp_port}",
    "-spade-env=${spade_env}",
    "-noop=${noop_flag}",
  ], ' ')

  twitch::service { 'globalviewcount':
    daemon_cmd            => $globalviewcount_cmd,
    predaemon             => [
                  "ulimit -v ${memory_limit}",
                  "ulimit -m ${memory_limit}",
                ],
    service_repo          => 'video/globalviewcount',
    user                  => 'nobody',
    env                   => $deploy_env,
    canary                => $canary,
    manage_service        => false,
    app_dir               => $globalviewcount_dir,
    consul_advertise_port => $listen_port,
  }

  envoy::service { 'globalviewcount':
    port => $listen_port,
  }
}
