# globalviewcount::shim
#
# A service that sits between our globalviewcount staging instances and
# edgeviewcounter running on all the edges, ensuring that the edges don't
# have to care about the setup of our staging environment and that the
# the hosts in the staging environment receive identical updates to make
# comparisons maximally meaningful.
class globalviewcount::shim (
  $deploy_env         = $globalviewcount::shim::params::deploy_env,
  $twitch_basedir     = $globalviewcount::shim::params::twitch_basedir
) inherits globalviewcount::shim::params {

  validate_string(
    $deploy_env,
    $twitch_basedir
  )

  $service = 'globalviewcount-shim'

  ::courier::install{ $service:
    env     => $deploy_env,
    repo    => 'video/globalviewcount-shim',
    basedir => $twitch_basedir
  }

  ::consul::service { $service:
    service_name => $service,
    consul_tags  => [$deploy_env],
    port         => $port_in,
    require      => Daemontools::Supervise[$service],
  }

  ::daemontools::supervise { $service:
    predaemon => [
      'exec 2>&1',
    ],
    wd        => "${twitch_basedir}/globalviewcount-shim/current",
    user      => 'nobody',
    daemon    => './bin/globalviewcount-shim',
    syslog    => 'local3'
  }
}
