class kinesis_client inherits kinesis_client::params {
  require java

  validate_absolute_path($install_dir)

  realize(Package['maven'])

  file { $install_dir:
    ensure => "directory"
  }

  file { "${install_dir}/consumers" :
    ensure  => "directory",
    require => File[$install_dir]
  }

  wget::fetch { 'fetch-kcl-tarball':
    source      => "https://s3-us-west-2.amazonaws.com/kcl-fork/kinesis-client-library-1.6.2-alpha.tar.gz",
    destination => "/tmp/kcl.tar.gz",
  }

  exec { "untar-kcl-tarball":
    command => "tar -xvzf /tmp/kcl.tar.gz -C ${install_dir} --strip-components=1",
    creates => "${install_dir}/pom.xml",
    require => [ Wget::Fetch["fetch-kcl-tarball"], File[$install_dir] ],
  }

  exec { "install-kcl":
    command  => join([
       "mvn",
       "clean",
       "dependency:copy-dependencies",
       "install",
       "-Dgpg.skip=true",
       ], " "),
     cwd     => $install_dir,
     require => [ Exec["untar-kcl-tarball"], File[$install_dir], Package["maven"] ],
     creates => "${install_dir}/amazon-kinesis-client-1.6.1.jar",
  }

}
