define kinesis_client::supervise (
  $executable,
  $stream_name,
  $application_name,
  $install_dir = '/usr/local/amazon-kinesis-client'
) {
  require kinesis_client
  require daemontools

  validate_absolute_path($executable)
  validate_string($stream_name)
  validate_string($application_name)

  kinesis_client::consumer { "kcl-${application_name}" :
    executable       => $executable,
    stream_name      => $stream_name,
    application_name => $application_name,
    install_dir      => $install_dir,
  }

  $appdir = "${install_dir}/consumers/${application_name}"
  validate_absolute_path($appdir)

  notify {"installing to ${appdir} under ${install_dir} (default is ${kinesis_client::params::install_dir})" :}

  daemontools::supervise { "${application_name}" :
    daemon_dir => '/var/lib/service',
    wd         => $appdir,
    down       => false,
    user       => 'nobody',
    syslog     => local3,
    daemon     => "${appdir}/run.sh 2>&1",
    require    => Kinesis_Client::Consumer["kcl-${application_name}"]
  }
}
