# == Class: twitch_trace_api
#
# twitch_trace_api installs and runs the
# release/trace/cmd/api binary for exporting trace transactions
class twitch_trace_api (
  $consul_environment = $twitch_trace_api::params::consul_environment,
  $deploy_environment = $twitch_trace_api::params::deploy_environment,
  $repository         = $twitch_trace_api::params::repository,
  $user               = $twitch_trace_api::params::user,
  $base_directory     = $twitch_trace_api::params::base_directory,
  ) inherits twitch_trace_api::params {

  validate_string($consul_environment, $deploy_environment)
  validate_re($repository, '[A-Za-z0-9_]/[A-Za-z0-9_]')

  require courier

  consul::service { 'trace-api':
    consul_tags => [$consul_environment],
  }

  # install the package via courier
  courier::install { 'trace':
    env     => $deploy_environment,
    repo    => $repository,
    basedir => $base_directory,
    require => Consul::Service['trace-api'],
  }

  daemontools::supervise { "trace_api":
    daemon_dir     => '/var/lib/service',
    down           => false,
    user           => $user,
    syslog         => local3,
    enable_cgroups => true,
    wd             => '/',
    daemon         => "${base_directory}/trace/current/bin/api",
    options        => join(
      [
       "-topic=\"trace-transactions\"",
       "-port=11143",
       "-workers=64",
       '2>&1',
    ],' '),
    predaemon      => [
      "export GODEBUG=gctrace=1",
    ],
    require        => Courier::Install['trace'],
  }
}
