# == Class: twitch_trace_collector
#
# twitch_trace_collector receives trace events from hosts with barrel
# and puts them in kafka
#
class twitch_trace_collector (
  $consul_environment = $twitch_trace_collector::params::consul_environment,
  $deploy_environment = $twitch_trace_collector::params::deploy_environment,
  $repository         = $twitch_trace_collector::params::repository,
  $user               = $twitch_trace_collector::params::user,
) inherits twitch_trace_collector::params {

  validate_string($consul_environment, $deploy_environment)
  validate_re($repository, '[A-Za-z0-9_]/[A-Za-z0-9_]')

  # require the courier module
  require courier

  # register the service in consul
  consul::service { 'trace-collector':
    consul_tags => [$consul_environment],
  }

  # install the package via courier
  courier::install { 'trace':
    env     => $deploy_environment,
    repo    => $repository,
    basedir => $base_directory,
    require => Consul::Service['trace-collector'],
  }

  daemontools::supervise { "trace_pbcollect":
    daemon_dir     => '/var/lib/service',
    down           => false,
    user           => $user,
    syslog         => local3,
    enable_cgroups => true,
    wd             => '/',
    daemon         => "${base_directory}/trace/current/bin/runpbcollect",
    options        => join([
      "-cmd=${base_directory}/trace/current/bin/pbcollect",
      '2>&1',
    ],' '),
    predaemon      => [
      "export GODEBUG=gctrace=1",
    ],
    require        => Courier::Install['trace'],
  }
}
