class zookeeper::install {
  include java

  # The Precise case
  archive { '/usr/local/src/cdh4-repository_1.0_all.deb':
    ensure      => 'present',
    source      => 'http://archive.cloudera.com/cdh4/one-click-install/precise/amd64/cdh4-repository_1.0_all.deb',
    provider    => 'wget',
    before      => Package['cloudera_repo'],
  }

  package { 'cloudera_repo':
    ensure   => installed,
    source   => '/usr/local/src/cdh4-repository_1.0_all.deb',
    provider => dpkg,
  }

  # Xenial
  apt::key {'cloudera_cdh5_key':
    source => 'https://archive.cloudera.com/cdh5/ubuntu/xenial/amd64/cdh/archive.key',
    id     => 'F36A89E33CC1BD0F71079007327574EE02A818DD',
  }

  archive { '/etc/apt/sources.list.d/cloudera.list':
    source      => 'https://archive.cloudera.com/cdh5/ubuntu/xenial/amd64/cdh/cloudera.list',
    provider    => 'wget',
    require     => [
      Apt::Key['cloudera_cdh5_key'],
      Apt::Pin['cloudera_pin'],
    ],
  }

  apt::pin { 'cloudera_pin':
    originator => 'Cloudera',
    priority   => 501,
  }

  # Both
  exec { 'apt-update-cloudera':
    command     => '/usr/bin/apt-get update',
    refreshonly => true,
    subscribe   =>  $::lsbdistcodename ? {
      'precise' => Package['cloudera_repo'],
      default   => Archive['/etc/apt/sources.list.d/cloudera.list'],
    },
  }

  package { [
    'zookeeper',
    'zookeeper-server',
  ]:
    ensure  => installed,
    require => Exec['apt-update-cloudera'],
  }
}
