require 'yaml'

def tmp_dir
  seed=srand.to_s[0..7]
  @tmp_dir ||= "/tmp/puppet.#{seed}"
end

def shell_deploy
  cmd = [
    "mkdir -p #{tmp_dir}",
    "cd #{tmp_dir}",
    "tar Jfx -",
    "echo \"#{hiera_yaml_mash}\" > hiera.yaml",
    puppet_apply,
    "rm -rf #{tmp_dir}"
  ]
  cmd.join(" && ")
end


def puppet_apply
  source_proxy = ". /etc/profile.d/proxy.sh"
  noop = ENV['REALLY_DO'].nil? ? '--noop' : ''
  puppet_args = %w{
    --show_diff
    --verbose
    --hiera_config=hiera.yaml
    --modulepath=modules
    manifests/site.pp
  }
  "#{source_proxy}; sudo -E puppet apply #{noop} #{puppet_args.join(' ')}"
end

def hiera_yaml_mash
  # take current hiera from git, update datadir for puppet apply
  hiera = YAML.load_file("hiera.yaml")
  hiera[:yaml] = {:datadir => './hiera'}
  hiera.to_yaml
end

namespace :deploy do
  desc "deploy current git HEAD to host"
  task :host, [:fqdn] do |t, args|
    ssh_user = ENV['SSH_USER'].nil? ? ENV['USER'] : ENV['SSH_USER']
    sh "git archive HEAD | xz -9 | ssh #{ssh_user}@#{args.fqdn} '#{shell_deploy}'"
  end
end
