require 'resolv'
require 'net/http'

def print_dns(h)
  resolv = Resolv::DNS.new
  h.keys.sort.each do |key|
    name = key
    ips = h[key]
    hostnames = ips.map do |ip|
      begin
        hostname = resolv.getname(ip)
      rescue Resolv::ResolvError
        hostname = "UNK"
      end
      uri = URI.parse("http://#{ip}:1935")
      http = Net::HTTP.new(uri.host, uri.port)
      http.open_timeout = 4
      http.read_timeout = 4
      begin
        resp = http.get('/')
        status = resp.code.to_i == 200
      rescue Net::HTTPRequestTimeOut, Timeout::Error
        status = false
      end
      "%s - %s - %s" % [ip, hostname, status ? 'UP' : 'DOWN']
    end
    puts "#{name}.justin.tv", hostnames.join("\n"), ''
  end
end

# Defunct, but useful reference for refactor
#namespace :dns do
#  desc "Check Live DNS Entries"
#  task :check_live do
#    live_dns_file = "files/misc/dns-data/includes/live.inc"
#    public_proxy_re = /^(live-[a-z]{3}(?!-priv)[^\s]*).+A\s+(\d+\.\d+\.\d+\.\d+)/
#    private_proxy_re = /^(live-[a-z]{3}-priv\d+[^\s]*).+A\s+(\d+\.\d+\.\d+\.\d+)/
#    public_proxies, private_proxies = Hash.new(Array.new), Hash.new(Array.new)
#    File.open(live_dns_file, 'r').each do |line|
#      if line =~ public_proxy_re
#        public_proxies[$1] += [$2]
#      elsif line =~ private_proxy_re
#        private_proxies[$1] += [$2]
#      end
#    end
#    puts "### Public Ingests"
#    print_dns(public_proxies)
#    puts "### Private Ingests"
#    print_dns(private_proxies)
#  end
#end
