namespace :puppet do
  desc "create tarball for pluginsync"
  task :pluginsync do |t, args|
    target = "modules/*/lib/{puppet,facter,puppetx,puppet_x}/"
    output = "pluginsync.tar.gz"
    sh <<-EOS
      basedir=/tmp/git_archive_puppet.$RANDOM
      mkdir -p $basedir
      git archive HEAD #{target} | tar xf - --strip-components=2 -C $basedir
      tar cfz #{output} -C $basedir .
      rm -rf $basedir
EOS
  end
end
