
def all_manifests
  'git ls-files *\*.pp'
end

namespace :test do
  desc "Validate All Manifests"
  task :validate do
    sh "#{all_manifests} | xargs puppet parser validate" do |ok, res|
      raise "Failed Manifest Validation Tests" if !ok
    end
  end

  desc "Lint All Manifests"
  task :lint do
    args = %w(
      --with-filename
      --error-level=error
    )
    sh "#{all_manifests} | xargs puppet-lint #{args.join(' ')}" do |ok, res|
      #raise "Failed Linting" if !ok
    end
  end

  desc 'Validate All Hiera YAML Files'
  task :hiera do
    errors = []
    FileList.new("hiera/**/*.yaml").each do |yamlfile|
      begin
        YAML.load_file(yamlfile)
      rescue Psych::SyntaxError => e
        errors << e.message
      end
    end
    raise "Failed YAML validation in:\n#{errors.join("\n")}" if errors.length > 0
  end
end

desc "Run all tests"
task :test do
  Rake::Task['test:validate'].invoke
  Rake::Task['test:hiera'].invoke
  Rake::Task['test:lint'].invoke
end
