# Functions for testing, helps our main code be readable.

test_fail() {
  if [ $1 -ne 0 ]; then
    echo "Puppet mainfest syntax: FAILED"
    echo "Exited with ${1} on file ${2}"
    exit $1
  fi
}

test_manifest() {
  puppet-lint "$1"
  test_fail $? "$1"
  puppet parser validate --verbose "$1"
  test_fail $? "$1"
}

test_yaml () {
  ruby -e "require 'yaml'; YAML.load_file('${1}')"
  test_fail $? "$1"
}
