#!/bin/bash
bindir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
source "${bindir}/functions.sh"

# Exit if we don't have anything to do. 
if [ $# -eq 0 ]
  then
    echo "No files to test"
    exit 0
fi

testfiles=$@

# Test manifest syntax
echo "Testing Puppet changes..."

for file in $testfiles; do
  if [ -f "$file" ]; then
    if [[ "$file" =~ .*pp$ ]]; then
      echo "$file"
      test_manifest "$file"
    elif [[ "$file" =~ .*hiera.* ]]; then
      echo "$file"
      test_yaml "$file"
    else
      echo "Ignoring ${file}"
    fi
  fi
done

echo "Puppet syntax: PASS"
