class remundo (
  $canary                    = false,
  $dc                        = '',
  $user                      = 'nobody',
  $svcname                   = 'remundo',
  $env                       = pick($::twitch_environment, $twitch_environment, 'production'),
  $envoy_port                = '5555',
  $nrdp_ensure              = 'present',
  $systemd_enabled           = false,
  $systemd_start_timeout_sec = '60',
) {

  if $dc != '' {
    $dc_flag = "-cluster ${dc}"
  }

  if $systemd_enabled == true {
    $systemd_running = 'running'
    $systemd_ensure  = 'present'
  } else {
    $systemd_running = 'stopped'
    $systemd_ensure  = 'absent'
  }

  twitch::service { 'remundo':
    canary                => $canary,
    env                   => $env,
    daemon_cmd            => "./remundo ${dc_flag} -environment ${env}",
    predaemon             => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh'],
    service_repo          => 'video/remundo',
    user                  => $user,
    daemontools_ensure    => 'absent',
    codedeploy_compat     => true,
  }

  $systemd_exec_cmd = "/opt/twitch/remundo/current/remundo ${dc_flag} -environment ${env}"

  twitch_systemd::unit_file {'video-remundo.service':
    ensure  => $systemd_ensure,
    content => template('remundo/remundo.service.erb'),
  }

  service { ['video-remundo']:
    ensure    => $systemd_running,
    enable    => $systemd_enabled,
    subscribe => Twitch_systemd::Unit_file['video-remundo.service'],
  }

  include twitch_nrdp

  twitch_nrdp::check { 'check_remundo':
    ensure         => $nrdp_ensure,
    command        => "/usr/bin/envoy-check --host ${::fqdn} --port ${envoy_port}",
    interval       => 5,
    retry          => 2,
    retry_interval => 1,
  }
}
