class rtqos_kinesis_consumer (
  $env         = pick($::twitch_environment, $twitch_environment, 'production'),
  $canary      = false,
  $svcname     = 'rtqos_kinesis_consumer',
  $user        = 'nobody',
  $concurrency = 0
) {

  include java

  twitch::service { 'rtqos_kinesis_consumer':
    env            => $env,
    canary         => $canary,
    manage_service => true,
    daemon_cmd     => './run',
    predaemon      => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh'],
    service_repo   => 'video/rtqos_kinesis_consumer',
    user           => $user,
    concurrency    => $concurrency
  }
}
