define sanzu_actions::anycast(
  $bgp_asn        = 64512,
  $bgp_community  = undef,
  $bgp_location   = undef,
  $check_interval = '10s',
  $check_cmd      = undef,
) {
  include sanzu_actions
  include bird

  validate_integer($bgp_asn)
  validate_integer($bgp_community)
  validate_ip_address($bgp_location)
  validate_string($check_interval)
  validate_string($check_cmd)

  bird::daemon { $name:
    protocol      => 'bgp',
    bgp_asn       => $bgp_asn,
    bgp_community => $bgp_community,
    bgp_announce  => [
      "${bgp_location}/32{32,32}"
    ],
  }

  twitch_anycast_health_enforcer::service { $name:
    addresses => [ $bgp_location ],
    healthy   => 'all',
    interval  => '10s',
    community => $bgp_community,
  }

  twitch_anycast_health_enforcer::servicecheck { $name:
    service => $name,
    type    => 'cmd',
    check   => $check_cmd,
  }
}
