class sanzu_actions (
  $user                = $sanzu_actions::params::user,
  $basedir             = $sanzu_actions::params::basedir,
  $project             = $sanzu_actions::params::project,
  $action_environments = $sanzu_actions::params::action_environments,
  $anycast_instances   = $sanzu_actions::params::anycast_instances,
) inherits sanzu_actions::params {
  include sanzu_actions::syslog

  validate_string($user)
  validate_absolute_path($basedir)
  validate_string($project)
  validate_array($action_environments)
  validate_hash($anycast_instances)

  sanzu_actions::instance { $action_environments: }
  create_resources(sanzu_actions::anycast, $anycast_instances)
}
