class sanzu_actions::syslog() {
  file { '/var/log/sanzu_actions':
    ensure  => directory,
    owner   => 'root',
    group   => 'syslog',
    mode    => '0775',
  }

  file { '/var/log/logcat':
    ensure  => directory,
    owner   => 'root',
    group   => 'syslog',
    mode    => '0775',
  }

  ::rsyslog::snippet { '40-netproxy':
    content => template("${module_name}/40-netproxy.conf.erb")
  }

  logrotate::rule{ 'sanzu_actions_source':
    ensure       => present,
    path         => '/var/log/sanzu_actions/data_source.log',
    postrotate   => '/usr/local/bin/rsyslog_reopen_logs.sh',
    rotate_every => 'day',
    missingok    => true,
    compress     => false,
    rotate       => 7,
    ifempty      => false,
    olddir       => '/var/log/archive',
    create       => true,
    create_mode  => '0644',
    create_owner => 'syslog',
    create_group => 'adm',
  }

  logrotate::rule{ 'logcat_source':
    ensure       => present,
    path         => '/var/log/logcat/data_source.log',
    postrotate   => '/usr/local/bin/rsyslog_reopen_logs.sh',
    rotate_every => 'day',
    missingok    => true,
    compress     => false,
    rotate       => 7,
    ifempty      => false,
    create       => true,
    create_mode  => '0644',
    create_owner => 'syslog',
    create_group => 'adm',
  }
}
