define sgauge::anycast (
  $ip,
  $community        = 16015,
  $healthcheck_port = 6060,
) {
  validate_string($name)
  if !is_ip_address($ip) {
    fail('ip must be an IP address')
  }

  # configure the anycast instance and its healthcheck. 
  twitch_anycast_health_enforcer::service { $name:
    addresses    => [$ip],
    community    => $community,
    service_port => $healthcheck_port,
    rise         => 3,
    fall         => 2,
  }
  # configure the healthcheck separate from the service to prevent duplicate resources.
  twitch_anycast_health_enforcer::servicecheck { $name:
    service => $name,
    type    => 'cmd',
    check   => "/usr/lib/nagios/plugins/check_http -H localhost -p ${healthcheck_port} -u /health/routable",
  }
}
