# sgauge::canal is a tool that collects, processes, and aggregates sFlow data.
#
# This data is produced by the routers and then fed into the video system.
#
class sgauge::canal (
  $deploy_environment      = pick($::twitch_environment, $twitch_environment, 'production'),
  $admin_port              = 6060,
  $app_dir                 = '/opt/twitch/canal',
  $aws_creds_file          = '/opt/twitch/canal/awsCreds',
  $aws_creds_profile       = 'twitch-video-aws',
  $aws_assume_role_arn     = '',
  $canal_awscreds_keyid    = 'video/canal/production/awscreds_keyid',
  $canal_awscreds_key      = 'video/canal/production/awscreds_key',
  $undecoded_queue_size    = 1024,
  $decoders                = 1024,
  $connection_count        = 35,
  $canary                  = false,
  $log_level               = 'info',
  $ports                   = [6343, 6344],
  $netflow_anycast_address = undef,
  $sflow_anycast_address   = undef,
  $address                 = '0.0.0.0',
  $reservoir_locations     = [],
  $benchmark_locations     = [],
  $statsd_host_port        = 'localhost:8125',
  $user                    = 'nobody',
) {
  include sgauge
  validate_string($deploy_environment, $address)
  validate_integer($admin_port)
  validate_array($ports, $reservoir_locations)

  envoy::service { 'canal':
    port => $admin_port,
  }

  if $sflow_anycast_address != undef {
    # The name remains canal for backwards compatibility with boxes that used
    # to have one anycast address.
    sgauge::anycast{ 'sg_sflow':
      ip               => $sflow_anycast_address,
      healthcheck_port => $admin_port,
    }
  }

  if $netflow_anycast_address != undef {
    sgauge::anycast{ 'sg_netflow':
      ip               => $netflow_anycast_address,
      healthcheck_port => $admin_port,
    }
  }

  $joined_ports = join($ports, ',')

  if count($reservoir_locations) >= 1 {
    $joined_reservoirs = join($reservoir_locations, ',')
    $reservoir_flag = "-reservoirs ${joined_reservoirs}"
  } else {
    $reservoir_flag = ''
  }

  if count($benchmark_locations) >= 1 {
    $joined_benchmarks = join($benchmark_locations, ',')
    $benchmark_flag = "-benchmarks ${joined_benchmarks}"
  } else {
    $benchmark_flag = ''
  }

  twitch_sandstorm_agent::template { 'canal_aws_creds':
    destination     => $aws_creds_file,
    restart_command => '/usr/bin/svc -h /etc/service/canal',
    contents        => template("${module_name}/canal_awsCreds.erb"),
  }

  twitch::service { 'canal':
    canary            => $canary,
    env               => $deploy_environment,
    daemon_cmd        => "./canal -ports ${joined_ports} -admin-port ${admin_port} -log ${log_level} -hostname ${::hostname} -environment ${deploy_environment} -bp ${undecoded_queue_size} -decoders ${decoders} ${reservoir_flag} ${benchmark_flag} -udp-host ${address} -connection-count ${connection_count} -statsd-host ${statsd_host_port} -awsCredsFile ${aws_creds_file} -awsCredsProfile ${aws_creds_profile} -awsAssumeRole ${aws_assume_role_arn}",
    # We want core dumps to be enabled thus the ulimit
    predaemon         => ['ulimit -S -c 2048000000 && . /etc/profile.d/proxy.sh',
        'if ! systemctl is-active --quiet video-milliner; then',
        '    echo "milliner is not up yet"',
        '    sleep 1',
        '    exit 1',
        'fi',
        '. /etc/milliner-client-env.sh'],
    service_repo      => 'video/canal',
    user              => $user,
    require           => Twitch_sandstorm_agent::Template['canal_aws_creds'],
    codedeploy_compat => true,
  }
}
