# The shimmy_agent class, when activated, defaults to ensuring the `latest` version
# of the shimmy-agent package is installed.
#
# To remove the shimmy_agent package give `absent` for the ensure param, run
# puppet, and then remove the shimmy_agent class from the list of classes in the
# hiera spec.
class shimmy_agent (
  $ensure  = $shimmy_agent::params::ensure,
  $version = $shimmy_agent::params::version,
) inherits shimmy_agent::params {

  # Set the package ensure parameter to absent or the version provided.
  case $ensure {
    'present': {
      $ensure_pkg   = $version
      $enable_check = true
    }
    'absent': {
      $ensure_pkg   = 'absent'
      $enable_check = false
    }
    default: {
      fail('shimmy_agent::ensure must be present or absent')
    }
  }

  package { 'video-tools-shimmy-agent':
    ensure      => $ensure_pkg,
    configfiles => 'replace',
  }

  sudo::conf { 'ttv-video-tools-shimmy-agent':
    ensure   => $ensure,
    priority => 99,
    require  => Package['video-tools-shimmy-agent'],
  }

  cron::job { 'shimmy-agent-install':
    ensure      => $ensure,
    command     => 'apt-get install -y video-tools-shimmy-agent >/dev/null 2>&1',
    user        => 'root',
    environment => [
      'DEBIAN_FRONTEND=noninteractive',
      'PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin:/usr/local/sbin',
    ],
    minute      => fqdn_rand(59, $title),
    hour        => fqdn_rand(23, $title),
  }

  if $ensure == 'present' {
    twitch_servicecheck::passive { 'shimmy-agent':
      command => 'check_http -H localhost -p 4288 -u http://localhost:4288/health',
    }
  }
}
