#!/bin/bash

PID_FILE="/var/run/skadi/skadi_flap.pid"

case $1 in
	start)
		echo $$ > $PID_FILE
		cd /home/jtv; /home/jtv/flap_watch.sh -s skadi -e prod -k be265ce2dc744830b28c68f508403099 &
		;;
	stop)  
		[[ ! -f $PID_FILE ]] && exit 0
		kill `cat $PID_FILE`
		rm $PID_FILE
		;;
	status)  
		PID=`cat $PID_FILE`
		if [[ ! -f $PID_FILE ]] || [[ ! -d "/proc/$PID" ]]; then
			echo "Not running"
			exit 1
		fi
		;;
	*)  
		echo "usage: $0 {start|stop|status}"
		;;
esac
