class skadi (
  $skadi_environment = $skadi::params::skadi_environment,
  $base_dir          = $skadi::params::base_dir,
) inherits skadi::params {
  include twitch_dta_codedeploy

  package { 'ssmforerunner':
    ensure => installed
  }

  class { 'skadi::install': }

  $app_dir="$base_dir/skadi"

  daemontools::supervise { 'skadi':
    user      => $user,
    syslog    => "local3",
    predaemon => [
      '# skadi',
      '# desc: An API and UI for interacting with the build system.',
      '# owner: devtools@twitch.tv',
      '# url: code.justin.tv/dta/skadi',
      "export APP=skadi",
      "export APPDIR=${app_dir}/current",
      "export ENVIRONMENT=${skadi_environment}",
      "export CONSUL_API=consul.internal.justin.tv",
    ],
    physical_cd => true,
    wd          => "$app_dir/current",
    daemon      => "ssmforerunner exec ./skadi 2>&1",
    daemon_dir  => '/var/lib/service',
    require     => [Package["ssmforerunner"], Class["skadi::install"]],
  }

  file { "/home/jtv/flap_watch.sh" :
    ensure  => 'present',
    source  => 'puppet:///modules/skadi/flap_watch.sh',
    mode    => '0755',
    owner   => $user,
  }

  file { "/home/jtv/skadi_flap_watch.sh" :
    ensure  => 'present',
    source  => 'puppet:///modules/skadi/skadi_flap_watch.sh',
    mode    => '0755',
    owner   => $user,
  }

  file { "/etc/monit/conf.d/skadi_flap_watch" :
    ensure  => 'present',
    source  => 'puppet:///modules/skadi/skadi_flap_watch.monit.config',
    mode    => '0644',
    owner   => $user,
  }

  file { '/var/run/skadi':
    ensure => 'directory',
    mode   => '0755',
    owner  => $user,
  }

}
