class slack::install inherits slack {
  if str2bool($is_canary) {
    $consul_tags = [$deploy_env, "${deploy_env}-canary"]
  } else {
    $consul_tags = [$deploy_env]
  }

  consul::service { 'deploy-target-slack':
    consul_tags => $consul_tags,
  }

  courier::install { 'slack':
    env     => $deploy_env,
    repo    => "common/slack",
    require => Consul::Service['deploy-target-slack'],
  }

  daemontools::supervise { 'slack':
    daemon_dir     => '/var/lib/service',
    user           => 'nobody',
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => '/opt/twitch/slack/current',
    daemon         => './slack 2>&1',
    predaemon      => [
      "export ENVIRONMENT=${deploy_env}",
      "export ROLLBAR_TOKEN=${rollbar_token}",
    ]
  }
}
