class statmon (
  $deploy_environment = pick($::twitch_environment, $twitch_environment, 'production'),
  $canary             = false,
  $rep_node           = false,
  $statmon_enable     = true,
  $edge_suffix        = '.no-abs.hls.ttvnw.net',
  $https_enable       = true,
)
{
  validate_bool($https_enable)
  $https_node = $https_enable ? {
    true  => '-https-enabled',
    false => '',
  }

  $envoy_port = $deploy_environment ? {
    'staging' => 5556,
    default   => 5555,
  }

  validate_bool($rep_node)
  $extra_options = $rep_node ? {
    true  => '-rep-node',
    false => "-varnish-health-url=http://localhost/health -varnish-https-health-url=https://${::pqdn}${edge_suffix}/health ${https_node}",
  }

  validate_bool($statmon_enable)
  $statmon_ensure = $statmon_enable ? {
    true  => 'present',
    false => 'absent',
  }

  $run_env = $canary ? {
    true    => 'canary',
    false   => $deploy_environment,
    default => $canary,
  }

  twitch::service {'statmon':
    env                => $deploy_environment,
    canary             => $canary,
    daemon_cmd         => "./statmon -status-port=${envoy_port} -running-env=${run_env} -net-interface=${::default_gateway_interface} ${extra_options}",
    predaemon          => [
      'exec 2>&1',
      'mkdir -p /var/run/statmon',
      'chown statmon: /var/run/statmon',
    ],
    service_repo       => 'video/statmon',
    group              => 'varnish',
    daemontools_ensure => $statmon_ensure,
    manage_service     => true,
    monit_ensure       => $statmon_ensure,
    monit_check_port   => $envoy_port,
    monit_check_mode   => 'http_cx',
    monit_down_kill    => true,
    require            => Package['varnish'],
  }

}
