class sysstat (
  $ensure      = $sysstat::params::ensure,
  $sa1_options = $sysstat::params::sa1_options,
  $sa2_options = $sysstat::params::sa2_options,
) inherits sysstat::params{

  $sysstat_ensure = $ensure ? {
    'absent' => 'stopped',
    default  => 'running'
  }

  $sysstat_enable = $systat_ensure ? {
    'stopped' => 'false',
    default   => 'true'
  }

  package { 'sysstat':
    ensure => installed,
  }

  file { '/etc/default/sysstat':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('sysstat/sysstat-default.erb'),
    notify  => Service['sysstat'],
    require => Package['sysstat'],
  }

  service { 'sysstat':
    ensure  => $sysstat_ensure,
    enable  => $sysstat_enable,
    require => [Package['sysstat'],File['/etc/default/sysstat']],
  }
}
