# modules/tabot/manifests/init.pp
class tabot (
  $base_dir          = $tabot::params::base_dir,
  $deploy_env        = $tabot::params::deploy_env,
  $project           = $tabot::params::project,
) inherits tabot::params {
  consul::service { 'deploy-target-tabot':
    consul_tags    => [$deploy_env],
  }

  courier::install{ 'tabot':
    env         => $deploy_env,
    repo        => $project,
    basedir     => $base_dir,
    require     => [
      Consul::Service['deploy-target-tabot'],
    ]
  }

  daemontools::supervise { 'tabot':
    user      => $user,
    syslog    => "local3",
    predaemon => [
        "export TABOT_ENVIRONMENT=${deploy_env}",
    ],
    physical_cd => true,
    wd          => "${base_dir}/current",
    daemon      => "/opt/twitch/tabot/current/scripts/entrypoint.sh 2>&1",
    daemon_dir     => '/var/lib/service',
    require     => [
      Courier::Install['tabot'],
    ]
  }
}
