# tenfoot class
class tenfoot (
  $use_courier         = $tenfoot::params::use_courier,
  $deploy_env          = $tenfoot::params::deploy_env,
  $basedir             = $tenfoot::params::basedir,
  $blue_listen_port    = $tenfoot::params::blue_listen_port,
  $blue_envoy_port     = $tenfoot::params::blue_envoy_port,
  $green_listen_port   = $tenfoot::params::green_listen_port,
  $green_envoy_port    = $tenfoot::params::green_envoy_port,
  $tenfoot_user        = $tenfoot::params::tenfoot_user,
  $project             = $tenfoot::params::project,
  $envoy_host          = $tenfoot::params::envoy_host,
  $statsd_host         = $tenfoot::params::statsd_host,
  $statsd_port         = $tenfoot::params::statsd_port,
  $statsd_rate         = $tenfoot::params::statsd_rate,
  $data_path           = $tenfoot::params::data_path,
  $log_level           = $tenfoot::params::log_level,
  $log_format          = $tenfoot::params::log_format,
  $startup_window      = $tenfoot::params::startup_window,
  $max_prefetch_window = $tenfoot::params::max_prefetch_window,
  $rewrite_configs     = $tenfoot::params::rewrite_configs,

) inherits tenfoot::params {

  validate_bool($use_courier)
  validate_string($deploy_env)
  validate_absolute_path($basedir)
  validate_integer($blue_listen_port)
  validate_integer($blue_envoy_port)
  validate_integer($green_listen_port)
  validate_integer($green_envoy_port)
  validate_string($tenfoot_user)
  validate_string($project)
  validate_string($envoy_host)
  validate_string($statsd_host)
  validate_integer($statsd_port)
  validate_numeric($statsd_rate)
  validate_absolute_path($data_path)
  validate_re($log_level, '^(ERROR|WARN|INFO|DEBUG)$')
  validate_string($log_format)
  validate_string($startup_window)
  validate_integer($max_prefetch_window)
  validate_string($rewrite_configs)

  if ($use_courier) {
    # The consul registration for the service is in tenfoot::instance.
    courier::install{ 'tenfoot':
      env     => $deploy_env,
      repo    => $project,
      basedir => $basedir,
      require => [
        Tenfoot::Instance['tenfoot_blue'],
        Tenfoot::Instance['tenfoot_green'],
        Class['courier'],
      ]
    }
  }

  # If this directory does not exist, `video/tenfoot` will not start; neither will `video/gotranscoder`, if the Tenfoot
  # client is enabled.
  file { '/var/run/tenfoot':
    ensure => 'directory',
    owner  => $tenfoot_user,
    group  => $tenfoot_user,
    mode   => '0755',
  }

  tenfoot::instance {
    'tenfoot_blue':
      listen_port => $blue_listen_port,
      envoy_port  => $blue_envoy_port,
      instance    => 'blue';

    'tenfoot_green':
      listen_port => $green_listen_port,
      envoy_port  => $green_envoy_port,
      instance    => 'green';
  }

  $tenfoot_listen_port = hiera('tenfoot_listen_port', '8080')

  class { 'twitch::haproxy::tenfoot':
    listen_port       => "$tenfoot_listen_port",
    blue_listen_port  => $blue_listen_port,
    green_listen_port => $green_listen_port,
  }
}
