# tenfoot instance class
define tenfoot::instance (
  $listen_port,
  $envoy_port,
  $instance,
  ) {

  include ::tenfoot
  $options = {
    # Options not exposed here:
    # - '-event-sock-path'
    # - '-statsd-enabled'

    # Shared between instances; generic.
    'envoy-host'          => $tenfoot::envoy_host,
    'statsd-host'         => $tenfoot::statsd_host,
    'statsd-port'         => $tenfoot::statsd_port,
    'statsd-rate'         => $tenfoot::statsd_rate,

    # Shared between instances; Tenfoot-specific.
    'data-path'           => $tenfoot::data_path,
    'log-level'           => $tenfoot::log_level,
    'log-format'          => $tenfoot::log_format,
    'startup-window'      => $tenfoot::startup_window,
    'max-prefetch-window' => $tenfoot::max_prefetch_window,
    'rewrite-configs'     => $tenfoot::rewrite_configs,
    'statsd-cohort'       => $tenfoot::deploy_env,

    # Options that vary between instances.
    'http'                => ":${listen_port}",  # Listen address (default ":8080")
    'envoy-port'          => $envoy_port,
  }
  $all_options = prefix(delete_undef_values($options), '-')

  ::daemontools::supervise { $name:
    daemon         => 'current/bin/tenfoot',
    daemon_dir     => '/var/lib/service',
    down           => $tenfoot::service_down,  # XXX: delete this line before production rollout
    options        => shell_join(join_keys_to_values($all_options, '=')),
    user           => $tenfoot::tenfoot_user,
    wd             => "${tenfoot::basedir}/tenfoot",
    syslog         => 'local3',
    manage_service => true,
    predaemon      => [
      "mkdir -p /var/run/tenfoot && chown -R ${tenfoot::tenfoot_user}: /var/run/tenfoot",
      'exec 2>&1',
    ],
  }

  ::consul::service { $name:
    service_name => 'tenfoot',
    consul_tags  => [$tenfoot::deploy_env, $instance],
    port         => $listen_port,
    require      => Daemontools::Supervise[$name],
  }
}
