# class tenfoot params
class tenfoot::params {
  ### For an individual instance of the Tenfoot daemon
  $blue_listen_port    = 8081
  $blue_envoy_port     = 11666
  $green_listen_port   = 8082
  $green_envoy_port    = 11667

  ### Shared by all instances of the Tenfoot daemon
  $tenfoot_user        = 'jtv'  # This must be the same user that `gotranscoder` runs as, or we will have socket permissions issues.
  $envoy_host          = '0.0.0.0'
  $statsd_host         = hiera('statsd_host', 'statsd.internal.justin.tv')
  $statsd_port         = hiera('statsd_port', 8125)
  $statsd_rate         = 0.1

  ### Shared, Tenfoot-specific
  $data_path           = '/dev/shm/archives'
  $log_level           = 'INFO'  # XXX:
  $log_format          = 'json'
  $startup_window      = '10s'
  $max_prefetch_window = 6
  $rewrite_configs     = '2016-01-01T00:00:00Z,transcoder'
  $service_down        = false

  ### Courier-related
  $use_courier         = true
  $deploy_env          = 'production'
  $basedir             = '/opt/twitch'  # XXX: use this, or the hiera-based 'twitch_basedir' arrangement?
  $project             = 'video/tenfoot'
}
