class tos_o_bot::install inherits tos_o_bot {
  $consul_tags = [$deploy_env]

  consul::service { 'deploy-target-tos-o-bot':
    consul_tags => $consul_tags,
  }

  courier::install { 'tos-o-bot':
    env     => $deploy_env,
    repo    => "ncaspar/tos-o-bot",
    require => Consul::Service['deploy-target-tos-o-bot'],
  }

  daemontools::supervise { 'tos-o-bot':
    daemon_dir     => '/var/lib/service',
    user           => 'nobody',
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => '/opt/twitch/tos-o-bot/current',
    daemon         => './tos-o-bot 2>&1',
    predaemon      => [
      "export ENVIRONMENT=${deploy_env}",
    ]
  }
}
