class twitch::crossdomain {
  include twitch_nginx
  $html_dir = $twitch_nginx::nginx_html_dir

  file { "${html_dir}/crossdomain.xml":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/${module_name}/crossdomain.xml",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
