class twitch::haproxy::almanac_lb(
  $listen_port,
  $backend_port,
  $primary_backend_url,
  $secondary_backend_url,
  $instname   = 'almanac-lb',
  $consul_env = 'production',
  $consul_name = $instname,
  $stats_port = 2018,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-almanac.pid',
    'maxconn'      => '4000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '32',
    'log-tag'      => 'haproxy_almanac',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-almanac.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'redispatch',
    ],
    'timeout' => [
      'queue 500',
    ]
  },
) {
  twitch_haproxy::instance { $instname:
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  class {'twitch::haproxy::frontends::almanac_in': 
    listen_port => $listen_port
  }
  class {'twitch::haproxy::backends::almanac_out':
    default_remote_port          => $backend_port,
    primary_url                  => $primary_backend_url,
    secondary_url                => $secondary_backend_url,
  }

   consul::service { $instname:
    service_name => $consul_name,
    consul_tags  => concat(['haproxy'], $consul_env),
    port         => $listen_port,
  }
}
